/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.main;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumStorageDirection;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.api.IConnectableItemAutoIO;
import com.lothrazar.storagenetwork.api.IItemStackMatcher;
import com.lothrazar.storagenetwork.block.main.NetworkModule;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.util.UtilInventory;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileMain
extends BlockEntity {
    public NetworkModule nw = new NetworkModule();

    public TileMain(BlockPos pos, BlockState state) {
        super((BlockEntityType)SsnRegistry.Tiles.MASTER.get(), pos, state);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        this.m_187480_();
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_() == null ? new CompoundTag() : pkt.m_131708_());
        super.onDataPacket(net, pkt);
    }

    public int insertStack(ItemStack stack, boolean simulate) {
        int totalInserted = this.nw.insertStack(stack, simulate);
        return totalInserted;
    }

    public ItemStack request(ItemStackMatcher matcher, int size, boolean simulate) {
        ItemStack result = this.nw.request(matcher, size, simulate);
        return result;
    }

    private DimPos getDimPos() {
        return new DimPos(this.f_58857_, this.f_58858_);
    }

    public void clearCache() {
        this.nw.ch.clearCache();
    }

    private void updateImports() {
        block0: for (IConnectable connectable : this.nw.getConnectables()) {
            boolean power;
            IItemHandler itemHandler;
            IConnectableItemAutoIO storage;
            if (connectable == null || connectable.getPos() == null || (storage = connectable.getPos().getCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO, null)) == null || storage.ioDirection() != EnumStorageDirection.IN || !storage.runNow(connectable.getPos(), this) || (itemHandler = storage.getItemHandler()) == null || storage.needsRedstone() && !(power = this.f_58857_.m_46753_(connectable.getPos().getBlockPos()))) continue;
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                int extractSize;
                ItemStack stackToImport;
                if (itemHandler.getStackInSlot(slot).m_41619_()) continue;
                ItemStack stackCurrent = itemHandler.getStackInSlot(slot).m_41777_();
                if (storage.getFilters() != null && storage.getFilters().isStackFiltered(stackCurrent)) continue;
                if (storage.isStockMode()) {
                    int filterSize = storage.getFilters().getStackCount(stackCurrent);
                    BlockEntity tileEntity = this.f_58857_.m_7702_(connectable.getPos().getBlockPos().m_142300_(storage.facingInventory()));
                    IItemHandler targetInventory = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
                    int chestHowMany = UtilInventory.countHowMany(targetInventory, stackCurrent);
                    if (chestHowMany > filterSize) {
                        int realSize = Math.min(chestHowMany - filterSize, 64);
                        StorageNetworkMod.log(" : stock mode import  realSize = " + realSize);
                        stackCurrent.m_41764_(realSize);
                    } else {
                        StorageNetworkMod.log(" : stock mode CANCEL: ITS NOT ENOUGH chestHowMany <= filter size ");
                        continue;
                    }
                }
                if ((stackToImport = itemHandler.extractItem(slot, extractSize = Math.min(storage.getTransferRate(), stackCurrent.m_41613_()), true)).m_41619_()) continue;
                int countUnmoved = this.insertStack(stackToImport, true);
                int countMoved = stackToImport.m_41613_() - countUnmoved;
                if (countMoved <= 0) continue;
                ItemStack actuallyExtracted = itemHandler.extractItem(slot, countMoved, false);
                this.insertStack(actuallyExtracted, false);
                continue block0;
            }
        }
    }

    private void updateProcess() {
    }

    private void updateExports() {
        Set<IConnectable> conSet = this.nw.getConnectables();
        block2: for (IConnectable connectable : conSet) {
            boolean power;
            IConnectableItemAutoIO storage;
            if (connectable == null || connectable.getPos() == null || (storage = connectable.getPos().getCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO, null)) == null || storage.ioDirection() != EnumStorageDirection.OUT || !storage.runNow(connectable.getPos(), this) || storage.needsRedstone() && !(power = this.f_58857_.m_46753_(connectable.getPos().getBlockPos()))) continue;
            for (IItemStackMatcher matcher : storage.getAutoExportList()) {
                ItemStack realExtractedStack;
                ItemStack requestedStack;
                if (matcher.getStack().m_41619_()) continue;
                int amtToRequest = storage.getTransferRate();
                boolean stockMode = storage.isStockMode();
                if (stockMode) {
                    StorageNetworkMod.log("stockMode == TRUE ; updateExports: attempt " + matcher.getStack());
                    try {
                        BlockEntity tileEntity = this.f_58857_.m_7702_(connectable.getPos().getBlockPos().m_142300_(storage.facingInventory()));
                        IItemHandler targetInventory = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
                        int stillNeeds = UtilInventory.containsAtLeastHowManyNeeded(targetInventory, matcher.getStack(), matcher.getStack().m_41613_());
                        if (stillNeeds == 0) {
                            StorageNetworkMod.log("stockMode continnue; canc");
                            continue;
                        }
                        amtToRequest = Math.min(stillNeeds, amtToRequest);
                        StorageNetworkMod.log("updateExports stock mode edited value: amtToRequest = " + amtToRequest);
                    }
                    catch (Throwable e) {
                        StorageNetworkMod.LOGGER.error("Error thrown from a connected block" + e);
                    }
                }
                if (matcher.getStack().m_41619_() || amtToRequest == 0 || (requestedStack = this.request((ItemStackMatcher)matcher, amtToRequest, true)).m_41619_()) continue;
                ItemStack insertedSim = storage.insertStack(requestedStack, true);
                if (!insertedSim.m_41619_()) {
                    int movedItems = requestedStack.m_41613_() - insertedSim.m_41613_();
                    if (movedItems <= 0) continue;
                    requestedStack.m_41764_(movedItems);
                }
                if ((realExtractedStack = this.request(new ItemStackMatcher(requestedStack, false, true), requestedStack.m_41613_(), false)).m_41619_()) continue;
                storage.insertStack(realExtractedStack, false);
                continue block2;
            }
        }
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileMain tile) {
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileMain tile) {
        tile.tick();
    }

    private void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.f_58857_.m_46467_() % (long)StorageNetworkMod.CONFIG.refreshTicks() == 0L || this.nw.shouldRefresh()) {
            this.nw.doRefresh(this.getDimPos());
        }
        this.updateImports();
        this.updateExports();
        this.updateProcess();
    }
}

